/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.animation;

import icyllis.modernui.animation.Applier;
import icyllis.modernui.view.UIManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Animation {
    private final int duration;
    private long startTime;
    private int delayTime;
    @Nullable
    private List<Applier> appliers;
    @Nullable
    private List<IListener> listeners;
    private boolean waiting = true;
    private boolean started = false;
    private boolean reversed = false;

    public Animation(int duration) {
        this.duration = duration;
    }

    public Animation applyTo(@Nonnull Applier applier) {
        if (this.appliers == null) {
            this.appliers = new ArrayList<Applier>();
        }
        this.appliers.add(applier);
        return this;
    }

    public Animation applyTo(Applier ... appliers) {
        if (this.appliers == null) {
            this.appliers = new ArrayList<Applier>();
        }
        Collections.addAll(this.appliers, appliers);
        return this;
    }

    public Animation withDelay(int delay) {
        this.delayTime = delay;
        return this;
    }

    public void listen(IListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IListener>();
        }
        this.listeners.add(listener);
    }

    public void start() {
        this.start0(false);
    }

    public void startFull() {
        this.start0(true);
    }

    private void start0(boolean isFull) {
        this.startTime = UIManager.getInstance().getDrawingTime() + (long)this.delayTime;
        this.waiting = false;
        this.reversed = false;
        this.started = false;
        if (this.appliers != null) {
            this.appliers.forEach(e -> e.record(this.reversed, isFull));
        }
        UIManager.getInstance().addAnimation(this);
    }

    public void invert() {
        this.invert0(false);
    }

    public void invertFull() {
        this.invert0(true);
    }

    private void invert0(boolean isFull) {
        this.startTime = UIManager.getInstance().getDrawingTime() + (long)this.delayTime;
        this.waiting = false;
        this.reversed = true;
        this.started = false;
        if (this.appliers != null) {
            this.appliers.forEach(e -> e.record(this.reversed, isFull));
        }
        UIManager.getInstance().addAnimation(this);
    }

    public void cancel() {
        this.waiting = true;
        this.started = false;
    }

    public void skipToStart() {
        this.cancel();
        if (this.appliers != null) {
            this.appliers.forEach(e -> {
                e.record(true, false);
                e.update(1.0f);
            });
        }
    }

    public void skipToEnd() {
        this.cancel();
        if (this.appliers != null) {
            this.appliers.forEach(e -> {
                e.record(false, false);
                e.update(1.0f);
            });
        }
    }

    public void update(long time) {
        if (this.waiting || time <= this.startTime) {
            return;
        }
        if (!this.started) {
            this.started = true;
            if (this.listeners != null) {
                this.listeners.forEach(e -> e.onAnimationStart(this, this.reversed));
            }
        }
        float p = Math.min((float)(time - this.startTime) / (float)this.duration, 1.0f);
        if (this.appliers != null) {
            this.appliers.forEach(e -> e.update(p));
        }
        if (p == 1.0f) {
            this.waiting = true;
            this.started = false;
            if (this.listeners != null) {
                this.listeners.forEach(e -> e.onAnimationEnd(this, this.reversed));
            }
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public boolean shouldRemove() {
        return this.waiting;
    }

    public static interface IListener {
        default public void onAnimationStart(@Nonnull Animation animation, boolean isReverse) {
        }

        default public void onAnimationEnd(@Nonnull Animation animation, boolean isReverse) {
        }
    }
}

